/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.crafting.block;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.darkhax.bookshelf.crafting.block.BlockIngredient;
import net.darkhax.bookshelf.crafting.block.IBlockIngredientSerializer;
import net.darkhax.bookshelf.serialization.Serializers;
import net.minecraft.block.BlockState;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public class BlockIngredientAny
extends BlockIngredient {
    public static final ResourceLocation ID = new ResourceLocation("bookshelf", "any");
    public static final Serializer SERIALIZER = new Serializer();
    private final List<BlockIngredient> components;
    private Set<BlockState> stateCache;

    public BlockIngredientAny(List<BlockIngredient> components) {
        this.components = components;
    }

    @Override
    public boolean test(BlockState t) {
        return this.components.stream().anyMatch(i -> i.test(t));
    }

    @Override
    public Collection<BlockState> getValidStates() {
        this.buildCache();
        return this.stateCache;
    }

    @Override
    public ResourceLocation getSerializeId() {
        return ID;
    }

    public void buildCache() {
        if (this.stateCache == null) {
            HashSet<BlockState> validStates = new HashSet<BlockState>();
            this.components.forEach(c -> {
                Collection<BlockState> childStates = c.getValidStates();
                childStates.forEach(s -> validStates.add((BlockState)s));
            });
            this.stateCache = validStates;
        }
    }

    static class Serializer
    implements IBlockIngredientSerializer<BlockIngredientAny> {
        Serializer() {
        }

        @Override
        public BlockIngredientAny read(JsonElement json) {
            ArrayList<BlockIngredient> ingredients = new ArrayList<BlockIngredient>();
            for (JsonElement elem : JSONUtils.func_151214_t((JsonObject)json.getAsJsonObject(), (String)"ingredients")) {
                ingredients.add(Serializers.BLOCK_INGREDIENT.read(elem));
            }
            return new BlockIngredientAny(ingredients);
        }

        @Override
        public JsonElement write(BlockIngredientAny ingredient) {
            JsonObject obj = new JsonObject();
            JsonArray array = new JsonArray();
            for (BlockIngredient component : ingredient.components) {
                array.add(Serializers.BLOCK_INGREDIENT.write(component));
            }
            obj.add("ingredients", (JsonElement)array);
            return obj;
        }

        @Override
        public BlockIngredientAny read(PacketBuffer buf) {
            List<BlockIngredient> components = Serializers.BLOCK_INGREDIENT.readList(buf);
            return new BlockIngredientAny(components);
        }

        @Override
        public void write(PacketBuffer buf, BlockIngredientAny ingredient) {
            Serializers.BLOCK_INGREDIENT.writeList(ingredient.components);
        }
    }
}

